///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	This file contains the base class for all export formats.
 *	\file		FLX_BaseFormat.h
 *	\author		Pierre Terdiman
 *	\date		April, 4, 2000
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __FLX_BASEFORMAT_H__
#define __FLX_BASEFORMAT_H__

	//! Base export format
	class ExportFormat
	{
		public:
		// Constructor/Destructor
										ExportFormat()	{}
		virtual							~ExportFormat()	{}

		// Exporter init
		virtual			bool			Init(bool motion)												= 0;

		// Main scene info
		virtual			bool			SetSceneInfo		(const MainDescriptor& maininfo)			= 0;

		// Export loop
		virtual			bool			ExportCamera		(const CameraDescriptor&		camera)		= 0;
		virtual			bool			ExportController	(const ControllerDescriptor&	controller)	= 0;
		virtual			bool			ExportHelper		(const HelperDescriptor&		helper)		= 0;
		virtual			bool			ExportLight			(const LightDescriptor&			light)		= 0;
		virtual			bool			ExportMaterial		(const MaterialDescriptor&		material)	= 0;
		virtual			bool			ExportMesh			(const MeshDescriptor&			mesh)		= 0;
		virtual			bool			ExportMotion		(const MotionDescriptor&		motion)		= 0;
		virtual			bool			ExportShape			(const ShapeDescriptor&			shape)		= 0;
		virtual			bool			ExportTexture		(const TextureDescriptor&		texture)	= 0;

		// End of export notification
		virtual			bool			EndExport			(const StatsDescriptor& stats)				= 0;

		// Exportation settings
		__forceinline	ExportFormat&	SetSettings(const ExportSettings& settings)	{ mSettings = settings; return *this;	}
		__forceinline	ExportFormat&	GetSettings(ExportSettings& settings)		{ settings = mSettings; return *this;	}

		// Output filename
		__forceinline	ExportFormat&	SetOutputFilename(const String& str)	{ mFilename = str;		return *this;	}

		// Log-string
						ExportFormat&	SetLogString(const String& str)			{ mLogString = str;		return* this;	}
						ExportFormat&	SetLogString(const char* str)			{ mLogString = str;		return* this;	}
						ExportFormat&	GetLogString(String& str)				{ str = mLogString;		return* this;	}
						ExportFormat&	ResetLogString()						{ mLogString.Reset();	return* this;	}
		public:
						ExportSettings	mSettings;		//!< Exportation settings
						String			mFilename;		//!< Output filename
		private:
						String			mLogString;		//!< A string to add to the logfile (see below)

		// The log-string has been added so that your exporter can output information in
		// Flexporter's text window. You can use it this way:
		// - Flexporter calls your custom exporter. The log-string is always null.
		// - Put your text in the string by using SetLogString.
		// - When control gets back to Flexporter, the string is automatically added to
		//	the internal text window.
		// - Then the string is reset for next call.
	};

#endif // __FLX_BASEFORMAT_H__
